<?php
	// Loading an extension based on OS
	if (!extension_loaded('gd'))
	{
	   if (strtoupper(substr(PHP_OS, 0, 3) == 'WIN'))
	   {
//	       dl('php_gd.dll');
	       dl('php_gd2.dll');
	   }
	   else
	   {
//	       dl('gd.so');
	       dl('gd2.so');
		}
	}
	
	// Or, the PHP_SHLIB_SUFFIX constant is available as of PHP 4.3.0
	if (!extension_loaded('gd'))
	{
		$prefix = (PHP_SHLIB_SUFFIX == 'dll') ? 'php_' : '';
//		dl($prefix . 'gd2.' . PHP_SHLIB_SUFFIX);
		dl($prefix . 'gd.' . PHP_SHLIB_SUFFIX);
	}

	require("admin/lib_inc.php");

	$UTMNorthing=0;
	$UTMEasting=0;

function LatLong_to_UTM($dLam, $dLat, $Lon)
{
	global $UTMNorthing, $UTMEasting;

	$PI=3.14159265;

	// Perform initialization
	$A = 6378206.4;
	$B = 6356584.8;
	$M0 = 0.9996;
	$E2 = ($A * $A - $B * $B) / ($A * $A);
	$EPS = ($A * $A - $B * $B) / ($B * $B);
	$E4 = $E2 * $E2;
	$E6 = $E4 * $E2;
	$E8 = $E6 * $E2;
	$AE = $A * (1.0 - $E2);
	$A0 = $AE * (1.0 + (3.0 / 4) * $E2 + (45.0 / 64.0) * $E4 + (175.0 / 256.0) * $E6 + (11025.0 / 16384.0) * $E8);
	$A1 = - $AE / 2.0 * ((3.0 / 4.0) * $E2 + (15.0 / 16.0) * $E4 + (525.0 / 512.0) * $E6 + (2205.0 / 2048.0) * $E8);
	$A2 = $AE / 4.0 * ((15.0 / 64.0) * $E4 + (105.0 / 256.0) * $E6 + (2205.0 / 4096.0) * $E8);
	$Err = - $AE / 6.0 * ((35.0 / 512.0) * $E6 + (315.0 / 2048.0) * $E8);

	// Following give UTM Zone number
	$Izone = floor((180.0 - $dLam) / 6.0 + 1.0);
	$Lam0 = ((183.0-6.0*$Izone)*$PI)/180.0;

	// Start conversion part of function
	$D = $Lam0 - ($Lon*$PI)/180.0;
	$D2 = $D * $D;
	$D3 = $D2 * $D;
	$D4 = $D3 * $D;
	$D5 = $D4 * $D;
	$D6 = $D5 * $D;
	$D7 = $D6 * $D;
	$D8 = $D7 * $D;

	$S = sin(($dLat*$PI)/180.0);
	$C = cos(($dLat*$PI)/180.0);
	$T = $S / $C;
	$T2 = $T * $T;
	$T4 = $T2 * $T2;
	$T6 = $T4 * $T2;
	$C2 = $C * $C;
	$C3 = $C2 * $C;
	$C4 = $C3 * $C;
	$C5 = $C4 * $C;
	$C6 = $C5 * $C;
	$C7 = $C6 * $C;

	$N2 = $EPS * $C * $C;
	$N4 = $N2 * $N2;
	$N = $A / sqrt(1.0 - $E2 * $S * $S);
	$AA0 = $N * $C;
	$AA1 = $N * $C3 * (1.0 - $T2 + $N2);
	$AA2 = $N * $C5 * (5.0 - 18.0 * $T2 + $T4 + 14.0 * $N2 - 58.0 * $T2 * $N2);
	$AA3 = $N * $S * $C7 * (61.0 - 479.0 * $T2 + 179.0 * $T4 - $T6);
	$Lat2=($dLat*$PI)/180.0;
	$B0 = $A0 * $Lat2 + $A1 * sin(2.0 * $Lat2) + $A2 * sin(4.0 * $Lat2) + $Err * sin(6.0 * $Lat2);
	$B1 = $N * $S * $C;
	$B2 = $N * $S * $C3 * (5.0 - $T2 + 9.0 * $N2 + 4.0 * $N4);
	$B3 = $N * $S * $C5 * (61.0 - 58.0 * $T2 + $T4 + 270.0 * $N2 - 33.0 * $T2 * $N2);
	$B4 = $N * $S * $C7 * (1385.0 - 3111.0 * $T2 + 543.0 * $T4 - $T6);

	$UTMEasting = $M0 * ($AA0 * $D + $AA1 * $D3 / 6.0 + $AA2 * $D5 / 120.0 + $AA3 * $D7 / 5040.0) + 500000.0;
	$UTMNorthing = $M0 * ($B0 + $B1 * $D2 / 2.0 + $B2 * $D4 / 24.0 + $B3 * $D6 / 720.0 + $B4 * $D8 / 40320.0);
}

	$PAYS=isset($_REQUEST["PAYS"])?$_REQUEST["PAYS"] : 0; 
	$FAMILY=isset($_REQUEST["FAMILY"])?$_REQUEST["FAMILY"] : -1; 

	if($FAMILY!=-1)
	{
		$sReqFam="and id_family=$FAMILY";
	}
	else
	{
		$sReqFam="";
	}
	$result = mysql_query( "select COUNT(*) as somme from oxg_zones, oxg_events where oxg_zones.id_country=$PAYS and info1=$PAYS and oxg_zones.id_zone=info2 and id_zone<>-1 $sReqFam");
	$row = mysql_fetch_array($result);
	$nb_ind_total = $row['somme'];
	
	if($nb_ind_total==0)
	{
		$nb_ind_total=1;
	}

	$result_info_pays = mysql_query( "select * from oxg_countries where id_country='$PAYS'");
	$row_info_pays = mysql_fetch_array($result_info_pays);
	$extension = strtolower($row_info_pays['extension']);

//	header("Content-type: image/jpeg");
//	$im = imagecreatefromjpeg("map$PAYS.jpg");
//	header("Content-type: image/png");
	$im = imagecreatefrompng("map/$extension.png");

	//couleur des zones
	//mysql_query("SET OPTION SQL_BIG_SELECTS=1") or die(": FAILED");
	//$result_zones = mysql_query( "select libelle, code, id_zone, pos_remp_x, pos_remp_y, coord_zone from oxg_zones where id_country='$PAYS' and id_zone<>-1");
	$result_zones = mysql_query( "select libelle, code, id_zone, pos_remp_x, pos_remp_y, coord_zone from oxg_zones, oxg_flashlist where country='$PAYS' and id_country=country and id_zone=zone $sReqFam GROUP BY id_zone");
	if(mysql_num_rows($result_zones)!=0)
	{
		while($row_zones = mysql_fetch_array($result_zones))
		{
			$result_info_zone = mysql_query( "select COUNT(*) as somme from oxg_events where info1=$PAYS and info2=$row_zones[id_zone] $sReqFam");
			while($row_info_zone = mysql_fetch_array($result_info_zone))
			{
				$orange = imagecolorallocate($im, 220-(($row_info_zone['somme']*220)/$nb_ind_total), 245, 245);
				ImageFill($im, $row_zones['pos_remp_x'], $row_zones['pos_remp_y'], $orange);
			}
		}
	}

	$sTypeCarte=substr($row_info_pays['coef'], 0, 1);
	if($sTypeCarte=="#")
	{
		list($ulPosX, $ulPosY, $ulTailleX, $ulTailleY) = split( ';', substr($row_info_pays['coef'], 1));
		$imgSize = getimagesize("map/$extension.png");
		$ulTailleImgX=$imgSize[0];
		$ulTailleImgY=$imgSize[1];
	}
	else
	{
		list( $dBaseLong, $dYlat, $dXlat, $dYlong, $dXlong) = split( ';', $row_info_pays['coef']);
	}

	//affichage des croix sur chacun des lieux
	//$result_pays = mysql_query( "select longitude, latitude from oxg_cities where id_country='$PAYS'");
	$result_pays = mysql_query("select longitude, latitude from oxg_cities, oxg_flashlist where country='$PAYS' and id_country=country and id_city=city $sReqFam GROUP BY id_city");
	if(mysql_num_rows($result_pays)!=0)
	{
		while($row = mysql_fetch_array($result_pays))
		{
			if($sTypeCarte=="#")
			{
				if($row['latitude']>0)
				{
					$y=((($row['latitude']+90)*$ulTailleY)/180)-$ulPosY;
					$y=$ulTailleImgY-$y;
				}
				else
				{
					$y=(((($row['latitude']+90)*$ulTailleY)/180)-$ulPosY);
					$y=$ulTailleImgY-$y;
				}
				$x=((($row['longitude']+180)*$ulTailleX)/360)-$ulPosX;
			}
			else
			{
				LatLong_to_UTM($dBaseLong, $row['latitude'], $row['longitude']);
				$x=$dXlat+$dYlat*$UTMEasting;
				$y=$dXlong+$dYlong*$UTMNorthing;
			}
			$rouge = imagecolorallocate($im, 200, 10, 10);
			imagesetpixel($im, $x, $y, $rouge);
			imagesetpixel($im, $x+1, $y, $rouge);
			imagesetpixel($im, $x-1, $y, $rouge);
			imagesetpixel($im, $x, $y+1, $rouge);
			imagesetpixel($im, $x, $y-1, $rouge);
		}
	}

	imagejpeg($im);
	imagedestroy($im);
?>